﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividualGet]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HospitalHealthProviderIndividualGet]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date:   07/10/2015
-- Description:   Gets the Hospital for Health Provider Individual
-- =============================================

CREATE PROCEDURE [hips].[HospitalHealthProviderIndividualGet]
(
	@HospitalId INT,
	@HealthProviderIndividualId INT = NULL,
	@Identifier VARCHAR(30) = NULL	
)
AS
BEGIN

	SELECT HospitalId,
           HealthProviderIndividualId,
           CisProviderIdentifier,
           PasProviderIdentifier,
           DateCreated,
           UserCreated,
           DateModified,
           UserModified 
	FROM [hips].[HospitalHealthProviderIndividual]
	WHERE HospitalId = @HospitalId 
	AND (PasProviderIdentifier = @Identifier OR @Identifier IS NULL)
	AND (HealthProviderIndividualId = @HealthProviderIndividualId OR @HealthProviderIndividualId IS NULL)
	
END
GO
